<?php

namespace App\Modules\PackageTour\Application\Index;

use App\Modules\PackageTour\Application\Index\IndexPackageTourResponse;
use App\Modules\PackageTour\Domain\IdPackageTour;
use App\Modules\PackageTour\Domain\PackageTour;
use App\Modules\PackageTour\Domain\PackageTourRepository;

final class PackageTourIndexer
{
    public function __construct(private PackageTourRepository $repository)
    {
    }

    public function __invoke(IdPackageTour $idPackageTour): IndexPackageTourResponse
    {
        return new IndexPackageTourResponse($this->repository->index($idPackageTour));
    }
}
