<?php

namespace App\Modules\Package\Application;

use App\Modules\Tour\Application\TourDaysGenerator;
use Illuminate\Support\Facades\DB;

class PackageDaysGenerator
{

    public function __construct()
    {
    }

    public function __invoke($year, $month, $tours)
    {
        $duration = 0;
        foreach ($tours as $t) {
            $t->duration = $duration;
            $duration += $t->Tour_Duration;
        }
        $data = array_map(fn ($tour) => $this->generateDaysTour($tour, $year, $month), $tours);
        return $this->createDayArray($data);
    }

    private function createDayArray(array $data)
    {
        $turn = [];
        if (count($data) == 0) {
            return [];
        }
        foreach ($data[0] as $day => $v) {
            $turn[$day] = [
                "date"      => $this->getDateFromArray($data, $day),
                "paxFree"   => $this->getPaxFreeFromArray($data, $day),
                'paxAmount' => $this->getPaxAmountFromArray($data, $day),
                'paxMin'    => $this->getPaxMinFromArray($data, $day),
                'lock'      => $this->getLockFromArray($data, $day)
            ];
        }
        return $turn;
    }

    private function getDateFromArray($data, $day)
    {
        return $data[0][$day]['date'];
    }

    private function getPaxFreeFromArray($data, $day)
    {
        $min = $data[0][$day]['paxFree'];
        for ($i = 1; $i < count($data); $i++) {
            if ($data[$i][$day] < $min) {
                $min = $data[$i][$day]['paxFree'];
            }
        }
        return $min;
    }

    private function getPaxAmountFromArray($data, $day)
    {
        $min = $data[0][$day]['paxAmount'];
        for ($i = 1; $i < count($data); $i++) {
            if ($data[$i][$day] < $min) {
                $min = $data[$i][$day]['paxAmount'];
            }
        }
        return $min;
    }

    private function getPaxMinFromArray($data, $day)
    {
        $min = $data[0][$day]['paxMin'];
        for ($i = 1; $i < count($data); $i++) {
            if ($data[$i][$day] > $min) {
                $min = $data[$i][$day]['paxMin'];
            }
        }
        return $min;
    }

    private function extractByDay(array $data, string $key, int $day)
    {
        return array_map(fn ($d) => $d[$day][$key], $data);
    }

    private function compare($fnCompare, array $valuesArray)
    {
        $length = count($valuesArray);
        $max = $valuesArray[0];
        for ($i = 1; $i < $length; $i++) {
            if ($fnCompare($valuesArray[$i], $max)) {
                $max = $valuesArray[$i];
            }
        }
        return $max;
    }

    private function max(array $valuesArray)
    {
        return $this->compare(fn ($v, $m) => $v > $m, $valuesArray);
    }

    private function min(array $valuesArray)
    {
        return $this->compare(fn ($v, $m) => $v < $m, $valuesArray);
    }

    private function getLockFromArray($data, $day)
    {
        return $this->max($this->extractByDay($data, 'lock', $day));
    }

    private function generateDaysTour($tourData, $year, $month)
    {

        $yearMonthStr = $year . '-' . $month . '-';
        $daysInMonth = cal_days_in_month(CAL_GREGORIAN, $month, $year);

        $oParam = [
            $tourData->Id_Tour,
            $month,
            $year,
            $tourData->duration
        ];
        $availableDays  = DB::select('call sp_client_tour_availability(?,?,?,?)', $oParam);
        $locks  = DB::select('call sp_tour_lock_list(?,?,?,?)', $oParam);
        $tour = DB::select('call sp_tour_index(?)', [$tourData->Id_Tour]);

        return (new TourDaysGenerator())
            ->__invoke(
                $daysInMonth,
                $yearMonthStr,
                $tour,
                $availableDays,
                $locks
            );
    }
}
