<?php

namespace App\Modules\ModuleNotification\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Modules\Domain\Structure\StructureModule;

class InsertModuleNotification
{

    /** constructor */
    public function __construct(
        private ModuleNotificationDescription $description,
        private ModuleNotificationType $type,
        private ModuleNotificationModule $module,
        private IdAdmin $idAdminCreate
    ) {
    }

    public function getDescription(): ModuleNotificationDescription
    {
        return $this->description;
    }
    public function getType(): ModuleNotificationType
    {
        return $this->type;
    }
    public function getModule(): ModuleNotificationModule
    {
        return $this->module;
    }
    public function getIdAdminCreate(): IdAdmin
    {
        return $this->idAdminCreate;
    }

    public static function fromModule(
        ModuleNotificationDescription $description,
        ModuleNotificationType $type,
        IdAdmin $idAdminCreate,
        StructureModule $module
    ) {
        return new self(
            $description,
            $type,
            new ModuleNotificationModule($module->name()),
            $idAdminCreate
        );
    }
}
