<?php

namespace App\Modules\Media\Domain;

use App\Modules\Shared\Domain\ValueObject\EnumValueObject;

final class MediaType extends EnumValueObject
{
    const IMAGE = 1;
    const VIDEO = 2;
    const AUDIO = 3;

    static public function values()
    {
        return [
            self::IMAGE,
            self::VIDEO,
            self::AUDIO,
        ];
    }

    public static function image(): MediaType
    {
        return new MediaType(MediaType::IMAGE);
    }

    public static function video(): MediaType
    {
        return new MediaType(MediaType::VIDEO);
    }

    public static function audio(): MediaType
    {
        return new MediaType(MediaType::AUDIO);
    }
}
