<?php

namespace App\Modules\Media\Application\Delete;

use App\Modules\Media\Domain\MediaPath;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteMediaQueryHandler implements QueryHandler
{
    public function __construct(private MediaDeleter $deleter)
    {
    }

    public function __invoke(DeleteMediaQuery $query): DeleteMediaResponse
    {

        $this->deleter->__invoke(new MediaPath($query->path()));
        return new DeleteMediaResponse();
    }
}
