<?php

namespace App\Modules\LeadPassenger\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadPassenger\Application\List\LeadPassengerListerResponse;
use App\Modules\LeadPassenger\Domain\LeadPassengerRepository;

final class LeadPassengerLister
{
    public function __construct(private LeadPassengerRepository $repository)
    {
    }

    public function __invoke(IdLeadBooking $idLeadBooking, string $action): LeadPassengerListerResponse
    {
        return new LeadPassengerListerResponse($this->repository->find($idLeadBooking, $action));
    }
}
