<?php

namespace App\Modules\LeadPassenger\Application\Create;

use App\Modules\LeadPassenger\Application\Create\LeadPassengerInserterResponse;
use App\Modules\LeadPassenger\Domain\LeadPassenger;
use App\Modules\LeadPassenger\Domain\LeadPassengerRepository;

final class LeadPassengerInserter
{
    public function __construct(private LeadPassengerRepository $repository)
    {
    }

    public function __invoke(LeadPassenger $leadPassenger): LeadPassengerInserterResponse
    {
        return new LeadPassengerInserterResponse($this->repository->insert($leadPassenger));
    }
}
