<?php

namespace App\Modules\LeadBookingTourPassenger\Application\Update;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\LeadBookingTourPassenger\Domain\IdLeadBookingTourPassenger;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassenger;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerStatus;
use App\Modules\LeadPassenger\Domain\IdLeadPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingTourPassengerUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourPassengerUpdater $updater)
    {
    }

    public function __invoke(LeadBookingTourPassengerUpdaterQuery $query): LeadBookingTourPassengerUpdaterResponse
    {
        $model = new LeadBookingTourPassenger(
            new LeadBookingTourPassengerStatus($query->getStatus()),
            new IdLeadBookingTour($query->getIdLeadBookingTour()),
            new IdLeadPassenger($query->getIdLeadPassenger()),
            new IdLeadBookingTourPassenger($query->getId()),
        );
        return $this->updater->__invoke($model);
    }
}
