<?php

namespace App\Modules\LeadBookingTourPassenger\Application\Create;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassenger;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerDateStart;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerGroup;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerNoPax;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerPickUp;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerStatus;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerType;
use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\LeadPassenger\Domain\IdLeadPassenger;

final class LeadBookingTourPassengerInserterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourPassengerInserter $inserter)
    {
    }

    public function __invoke(LeadBookingTourPassengerInserterQuery $query): LeadBookingTourPassengerInserterResponse
    {
        $model = new LeadBookingTourPassenger(
            new LeadBookingTourPassengerStatus($query->getStatus()),
            new IdLeadBookingTour($query->getIdLeadBookingTour()),
            new IdLeadPassenger($query->getIdLeadPassenger()),
        );
        return $this->inserter->__invoke($model);
    }
}
