<?php

namespace App\Modules\LeadBookingTour\Application\UpdateDate;

use App\Modules\LeadBookingTour\Application\Update\LeadBookingTourUpdaterResponse;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourRepository;
use App\Modules\LeadBookingTour\Domain\UpdateLeadBookingTour;

final class LeadBookingTourDateUpdater
{
    public function __construct(private LeadBookingTourRepository $repository)
    {
    }

    public function __invoke(UpdateLeadBookingTour $leadBookingTour): LeadBookingTourUpdaterResponse
    {
        return new LeadBookingTourUpdaterResponse($this->repository->update($leadBookingTour));
    }
}
