<?php

namespace App\Modules\LeadBookingTour\Application\Delete;

use App\Modules\LeadBookingTour\Application\Delete\LeadBookingTourDeleterResponse;
use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourRepository;

final class LeadBookingTourDeleter
{
    public function __construct(private LeadBookingTourRepository $repository)
    {
    }

    public function __invoke(IdLeadBookingTour $idLeadBookingTour): LeadBookingTourDeleterResponse
    {
        return new LeadBookingTourDeleterResponse($this->repository->delete($idLeadBookingTour));
    }
}
