<?php

namespace App\Modules\LeadBookingServicePassenger\Application\List;

use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingServicePassengerListerQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingServicePassengerLister $inserter)
    {
    }

    public function __invoke(LeadBookingServicePassengerListerQuery $query): LeadBookingServicePassengerListerResponse
    {
        return $this->inserter->__invoke(
            new IdLeadBookingService($query->getIdLeadBookingService()),
            $query->getAction()
        );
    }
}
