<?php

namespace App\Modules\LeadBookingService\Application\Update;

use App\Modules\LeadBookingService\Domain\Id;
use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\LeadBookingService\Domain\LeadBookingService;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceQuantity;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceStatus;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceType;
use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingServiceUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingServiceUpdater $updater)
    {
    }

    public function __invoke(LeadBookingServiceUpdaterQuery $query): LeadBookingServiceUpdaterResponse
    {
        $model = new LeadBookingService(
            new LeadBookingServiceQuantity($query->quantity()),
            new LeadBookingServiceType($query->type()),
            new LeadBookingServiceStatus($query->status()),
            new IdLeadBookingTour($query->idLeadBookingTour()),
            new Id($query->idService()),
            new IdLeadBookingService($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
