<?php

namespace App\Modules\LeadBookingService\Application\Create;

use App\Modules\LeadBookingService\Application\Create\LeadBookingServiceInserterResponse;
use App\Modules\LeadBookingService\Domain\LeadBookingService;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceRepository;

final class LeadBookingServiceInserter
{
    public function __construct(private LeadBookingServiceRepository $repository)
    {
    }

    public function __invoke(LeadBookingService $leadBookingService): LeadBookingServiceInserterResponse
    {
        return new LeadBookingServiceInserterResponse($this->repository->insert($leadBookingService));
    }
}
