<?php

namespace App\Modules\LeadBookingPackage\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class InsertLeadBookingPackageQuery implements Query
{
    public function __construct(
        private string $leadBookingTourDateStart,
        private int $leadBookingTourType,
        private int $idLeadBooking,
        private int $idPackage,
        private int $passengers
    ) {
    }
    public function leadBookingTourDateStart(): string
    {
        return $this->leadBookingTourDateStart;
    }
    public function leadBookingTourType(): int
    {
        return $this->leadBookingTourType;
    }
    public function idLeadBooking(): int
    {
        return $this->idLeadBooking;
    }
    public function idPackage(): int
    {
        return $this->idPackage;
    }
    public function passengers(): int
    {
        return $this->passengers;
    }
}
