<?php

namespace App\Modules\LeadBooking\Application\Create;

use App\Modules\LeadBooking\Application\Create\LeadBookingInserterResponse;
use App\Modules\LeadBooking\Domain\LeadBooking;
use App\Modules\LeadBooking\Domain\LeadBookingRepository;

final class LeadBookingInserter
{
    public function __construct(private LeadBookingRepository $repository)
    {
    }

    public function __invoke(LeadBooking $leadBooking): LeadBookingInserterResponse
    {
        return new LeadBookingInserterResponse($this->repository->insert($leadBooking));
    }
}
