<?php

namespace App\Modules\Lead\Application\Delete;

use App\Modules\Lead\Application\Delete\LeadDeleterResponse;
use App\Modules\Lead\Domain\IdLead;
use App\Modules\Lead\Domain\LeadRepository;

final class LeadDeleter
{
    public function __construct(private LeadRepository $repository)
    {
    }

    public function __invoke(IdLead $idLead): LeadDeleterResponse
    {
        return new LeadDeleterResponse($this->repository->delete($idLead));
    }
}
