<?php

namespace App\Modules\Image\Domain;

class ImageStatus {

    private int $value;

    public const DELETED = 0;
    public const INACTIVE = 1;
    public const ACTIVE = 2;

    public function __construct (
        int $value
    ) {
        $valid = [ self::DELETED, self::INACTIVE, self::ACTIVE ];
        $this->value = in_array($value, $valid) ? $value : self::DELETED;
    }

    public function getValue() { return $this->value; }
    
}