<?php

namespace App\Modules\Image\Application;

use App\Modules\Image\Domain\ImageRepository;
use App\Modules\Shared\Domain\RequestAction;
use App\Modules\Shared\Validator\Domain\ListInput;

class ImageListCounter {

    private ImageRepository $repository;

    public function __construct(
        ImageRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke (RequestAction $action, ListInput $listInput) {
        return $this->repository->listCount($action, $listInput);
    }
}