<?php

namespace App\Modules\Image\Application;

use App\Modules\Image\Domain\BasicImage;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Image\Domain\Image;
use App\Modules\Image\Domain\ImageExtension;
use App\Modules\Image\Domain\ImageFilesize;
use App\Modules\Image\Domain\ImageRepository;
use App\Modules\Image\Domain\ImageStatus;
use App\Modules\Image\Domain\ImageThumbUrl;
use App\Modules\Image\Domain\ImageUrl;

class ImageInserter {

    private ImageRepository $repository;

    public function __construct(
        ImageRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke (BasicImage $basicImage, $idLanguage) {
        return $this->repository->insert(
            new Image(
                new ImageUrl($basicImage->getUrl()),
                new ImageThumbUrl($basicImage->getThumbnail()),
                new ImageFilesize($basicImage->getFilesize()),
                new ImageExtension($basicImage->getExtension()),
                new ImageStatus(ImageStatus::INACTIVE)
            ),
            $idLanguage
        );
    }
}