<?php

namespace App\Modules\Image\Application;

use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Image\Domain\IdImage;
use App\Modules\Image\Domain\ImagePath;
use App\Modules\Image\Domain\ImageRepository;
use App\Modules\Shared\Application\ResponseManager;

class ImageIndexer {

    private ImageRepository $repository;

    public function __construct(
        ImageRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke (IdImage $id, IdLanguage $idLanguage, ImagePath $imagePath) {
        return $this->repository->index($id, $idLanguage, $imagePath);
    }
}