<?php

namespace App\Modules\HtlTypeRoom\Infrastructure;

use App\Modules\HtlTypeRoom\Domain\HtlTypeRoom;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomRepository;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlHtlTypeRoomRepository implements HtlTypeRoomRepository
{

    public function find(StorageCriteria $criteria): HtlTypeRoom | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return HtlTypeRoom::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => HtlTypeRoom::fromDTO($btp), $criteria->run());
    }

    public function insert(HtlTypeRoom $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(HtlTypeRoom $value)
    {
        return DBRequester::requestUpdate($value);
    }

    public function delete(IdHtlTypeRoom $id)
    {
        return Requester::requestUpdate(
            'CALL sp_htl_type_room_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
