<?php

namespace App\Modules\HtlTypeRoom\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexHtlTypeRoom implements StorageCriteria
{

    public function __construct(
        private IdHtlTypeRoom $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlTypeRoom::select('`htc`');

        return DB::select(
            "SELECT $select
            FROM `t_htl_type_room` `htc`
            WHERE `htc`.`Id_HtlTypeRoom` = ?
            AND `htc`.`HtlTypeRoom_Status` <> 0",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new HtlTypeRoomNotFound();
        }
        return $data[0];
    }
}
