<?php

namespace App\Modules\HtlTypeRoom\Application\Update;

use App\Modules\HtlTypeRoom\Application\Index\HtlTypeRoomIndexer;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomAbrv;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomName;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateHtlTypeRoomQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlTypeRoomUpdater $updater,
        private HtlTypeRoomIndexer $indexer
    ) {
    }

    public function __invoke(UpdateHtlTypeRoomQuery $query): UpdateHtlTypeRoomResponse
    {
        $index = $this->indexer->__invoke(new IdHtlTypeRoom($query->id()), true);
        $index->setName(new HtlTypeRoomName($query->name()));
        $index->setAbrv(new HtlTypeRoomAbrv($query->abrv()));
        $index->setStatus(new HtlTypeRoomStatus($query->status()));
        $this->updater->__invoke($index);
        return new UpdateHtlTypeRoomResponse();
    }
}
