<?php

namespace App\Modules\HtlTypeRoom\Application\List;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomRepository;
use App\Modules\HtlTypeRoom\Domain\ListHtlTypeRoom;

final class HtlTypeRoomLister
{
    public function __construct(private HtlTypeRoomRepository $repository)
    {
    }

    public function __invoke(IdHtlCamp $idHtlCamp, string $action)
    {
        return $this->repository->search(new ListHtlTypeRoom($idHtlCamp, $action));
    }
}
