<?php

namespace App\Modules\HtlTypeCamp\Infrastructure;

use App\Modules\HtlTypeCamp\Domain\HtlTypeCamp;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampRepository;
use App\Modules\HtlTypeCamp\Domain\IdHtlTypeCamp;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlHtlTypeCampRepository implements HtlTypeCampRepository
{

    public function find(StorageCriteria $criteria): HtlTypeCamp | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return HtlTypeCamp::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => HtlTypeCamp::fromDTO($btp), $criteria->run());
    }

    public function insert(HtlTypeCamp $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(HtlTypeCamp $value)
    {
        return DBRequester::requestUpdate($value);
    }

    public function delete(IdHtlTypeCamp $id)
    {
        return Requester::requestUpdate(
            'CALL sp_htl_type_camp_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
