<?php

namespace App\Modules\HtlCampSchedule\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexHtlCampSchedule implements StorageCriteria
{

    public function __construct(
        private IdHtlCampSchedule $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlCampSchedule::select('`hcs`');

        return DB::select(
            "SELECT $select
            FROM `t_htl_camp_schedule` `hcs`
            WHERE `hcs`.`Id_HtlCampSchedule` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new HtlCampScheduleNotFound();
        }
        return $data[0];
    }
}
