<?php

namespace App\Modules\HtlCampSchedule\Domain;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class HtlCampSchedule extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlCampSchedule::class, 'Id_HtlCampSchedule', 'primary'),
            new AggregateAttribute('date', HtlCampScheduleDate::class, 'HtlCampSchedule_Date'),
            new AggregateAttribute('dateSchedule', HtlCampScheduleDateSchedule::class, 'HtlCampSchedule_DateSchedule'),
            new AggregateAttribute('fromCamp', HtlCampScheduleFromCamp::class, 'HtlCampSchedule_FromCamp'),
            new AggregateAttribute('availability', HtlCampScheduleAvailability::class, 'HtlCampSchedule_Availability'),
            new AggregateAttribute('amountUsage', HtlCampScheduleAmountUsage::class, 'HtlCampSchedule_AmountUsage'),
            new AggregateAttribute('lock', HtlCampScheduleLock::class, 'HtlCampSchedule_Lock'),
            new AggregateAttribute('idHtlCamp', IdHtlCamp::class, 'Id_HtlCamp'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_camp_schedule';
    }

    public function __construct(
        protected IdHtlCampSchedule $id,
        protected HtlCampScheduleDate $date,
        protected HtlCampScheduleDateSchedule $dateSchedule,
        protected HtlCampScheduleFromCamp $fromCamp,
        protected HtlCampScheduleAvailability $availability,
        protected HtlCampScheduleAmountUsage $amountUsage,
        protected HtlCampScheduleLock $lock,
        protected IdHtlCamp $idHtlCamp
    ) {
    }

    public function id(): IdHtlCampSchedule
    {
        return $this->id;
    }

    public function date(): HtlCampScheduleDate
    {
        return $this->date;
    }

    public function dateSchedule(): HtlCampScheduleDateSchedule
    {
        return $this->dateSchedule;
    }

    public function fromCamp(): HtlCampScheduleFromCamp
    {
        return $this->fromCamp;
    }

    public function availability(): HtlCampScheduleAvailability
    {
        return $this->availability;
    }

    public function amountUsage(): HtlCampScheduleAmountUsage
    {
        return $this->amountUsage;
    }

    public function lock(): HtlCampScheduleLock
    {
        return $this->lock;
    }

    public function idHtlCamp(): IdHtlCamp
    {
        return $this->idHtlCamp;
    }

    public function setDate(HtlCampScheduleDate $date): void
    {
        $this->date = $date;
    }

    public function setDateSchedule(HtlCampScheduleDateSchedule $dateSchedule): void
    {
        $this->dateSchedule = $dateSchedule;
    }

    public function setLock(HtlCampScheduleLock $lock): void
    {
        $this->lock = $lock;
    }

    public function setFromCamp(HtlCampScheduleFromCamp $fromCamp): void
    {
        $this->fromCamp = $fromCamp;
    }

    public function setAvailability(HtlCampScheduleAvailability $availability): void
    {
        $this->availability = $availability;
    }

    public function setAmountUsage(HtlCampScheduleAmountUsage $amountUsage): void
    {
        $this->amountUsage = $amountUsage;
    }

    public function isAvailable(int $amount): bool
    {
        return $this->availability->value() - $this->amountUsage->value() >= $amount;
    }
}
