<?php

namespace App\Modules\HtlCampSchedule\Application\Create;

use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\HtlCampSchedule\Domain\HtlCampSchedule;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleAmountUsage;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleAvailability;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleDate;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleDateSchedule;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleFromCamp;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleLock;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampScheduleCreator $creator)
    {
    }

    public function __invoke(CreateHtlCampScheduleQuery $query): CreateHtlCampScheduleResponse
    {
        $model = new HtlCampSchedule(
            new IdHtlCampSchedule(0),
            new HtlCampScheduleDate($query->date()),
            new HtlCampScheduleDateSchedule($query->dateSchedule()),
            new HtlCampScheduleFromCamp($query->fromCamp()),
            new HtlCampScheduleAvailability($query->availability()),
            new HtlCampScheduleAmountUsage($query->amountUsage()),
            new HtlCampScheduleLock($query->lock()),
            new IdHtlCamp($query->idHtlCamp())
        );
        return new CreateHtlCampScheduleResponse($this->creator->__invoke($model));
    }
}
