<?php

namespace App\Modules\HtlCampSchedule\Application\ChangeUsage;

use App\Modules\HtlCampSchedule\Application\Update\HtlCampScheduleUpdater;
use App\Modules\HtlCampSchedule\Domain\HtlCampSchedule;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleAmountUsage;
use App\Modules\Shared\Exceptions\InvalidRequestException;

final class HtlCampScheduleUsageChanger
{
    public function __construct(
        private HtlCampScheduleUpdater $updater
    ) {
    }

    public function __invoke(HtlCampSchedule $model, int $amountBefore, int $amountAfter)
    {
        $model->setAmountUsage(new HtlCampScheduleAmountUsage($model->amountUsage()->value() + $amountAfter - $amountBefore));
        $this->updater->__invoke($model);
    }
}
