<?php

namespace App\Modules\HtlCampLock\Infrastructure;

use App\Modules\HtlCampLock\Domain\HtlCampLock;
use App\Modules\HtlCampLock\Domain\HtlCampLockRepository;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;

class MysqlHtlCampLockRepository implements HtlCampLockRepository
{

    public function find(StorageCriteria $criteria): HtlCampLock | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return HtlCampLock::fromDTO($data);
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn ($btp) => HtlCampLock::fromDTO($btp), $criteria->run());
    }

    public function insert(HtlCampLock $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(HtlCampLock $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
