<?php

namespace App\Modules\HtlCampLock\Application\Index;

use App\Modules\HtlCampLock\Application\HtlCampLockResponse;
use App\Modules\HtlCampLock\Domain\IdHtlCampLock;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexHtlCampLockQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampLockIndexer $inserter)
    {
    }

    public function __invoke(IndexHtlCampLockQuery $query): HtlCampLockResponse
    {
        $model = $this->inserter->__invoke(new IdHtlCampLock($query->getId()));
        return new HtlCampLockResponse(
            $model->id()->value(),
            $model->date()->value(),
            $model->dateStart()->value(),
            $model->amount()->value(),
            $model->status()->value(),
            $model->lock()->value(),
            $model->remark()->value(),
            $model->idHtlCampSchedule()->value(),
            $model->idBookingTour()->value(),
        );
    }
}
