<?php

namespace App\Modules\HtlCampLock\Application\CreateByTour;

use App\Modules\HtlCampLock\Application\CreateByTour\GenerateLockFromTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateByTourHtlCampLockQueryHandler implements QueryHandler
{
    public function __construct(
        private GenerateLockFromTour $creator,
    ) {
    }

    public function __invoke(CreateByTourHtlCampLockQuery $query): CreateByTourHtlCampLockResponse
    {
        $create = $this->creator->__invoke(
            $query->idTour(),
            $query->dateStart(),
            $query->passengerAmount()
        );
        return new CreateByTourHtlCampLockResponse($create);
    }
}
