<?php

namespace App\Modules\HtlCampLock\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateHtlCampLockQuery implements Query
{
    public function __construct(
        private string $date,
        private string $dateStart,
        private int $amount,
        private int $status,
        private int $idHtlCamp,
    ) {
    }

    public function date(): string
    {
        return $this->date;
    }
    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function amount(): int
    {
        return $this->amount;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idHtlCamp(): int
    {
        return $this->idHtlCamp;
    }
}
