<?php

namespace App\Modules\HtlCampBookingPassenger\Application\ListByHtlCampSchedule;

use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerRepository;
use App\Modules\HtlCampBookingPassenger\Domain\ListByScheduleHtlCampBookingPassenger;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;

final class ByHtlCampScheduleHtlCampBookingPassengerLister
{
    public function __construct(private HtlCampBookingPassengerRepository $repository)
    {
    }

    public function __invoke(IdHtlCampSchedule $idHtlCampSchedule, string $action)
    {
        return $this->repository->searchBySchedule(new ListByScheduleHtlCampBookingPassenger($idHtlCampSchedule, $action));
    }
}
