<?php

namespace App\Modules\HtlCampBookingPassenger\Application\List;

use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerRepository;
use App\Modules\HtlCampBookingPassenger\Domain\ListHtlCampBookingPassenger;

final class HtlCampBookingPassengerLister
{
    public function __construct(private HtlCampBookingPassengerRepository $repository)
    {
    }

    public function __invoke(IdHtlCampBooking $idHtlCampBooking, string $action)
    {
        return $this->repository->search(new ListHtlCampBookingPassenger($idHtlCampBooking, $action));
    }
}
