<?php

namespace App\Modules\HtlCampBooking\Domain;

use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListByHtlCampScheduleHtlCampBooking implements StorageCriteria
{

    public function __construct(
        private IdHtlCampSchedule $idHtlCampSchedule,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlCampBooking::select('`hcb`');
        if ($this->action == 'all') {
            $where = '`hcb`.`HtlCampBooking_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`hcb`.`HtlCampBooking_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`hcb`.`HtlCampBooking_Status` = 0';
        } else {
            $where = '`hcb`.`HtlCampBooking_Status` = 2';
        }
        return DB::select(
            "SELECT $select,
                `hc`.`Id_HtlCamp`,
                `hc`.`HtlCamp_Name`,
                `hc`.`HtlCamp_Abrv`,
                `hc`.`HtlCamp_Icon`,
                `hc`.`HtlCamp_Icon_Thumb`,
                `hc`.`HtlCamp_Availability`,
                `hc`.`HtlCamp_Status`,
                `hc`.`Id_HtlTypeCamp`
            FROM `t_htl_camp_booking` `hcb`
            INNER JOIN `t_htl_camp_schedule` `hcs` ON `hcs`.`Id_HtlCampSchedule` = `hcb`.`Id_HtlCampSchedule`
            INNER JOIN `t_htl_camp` `hc` ON `hc`.`Id_HtlCamp` = `hcs`.`Id_HtlCamp`
            WHERE `hcb`.`Id_HtlCampSchedule` = ?
            AND $where",
            [$this->idHtlCampSchedule->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
