<?php

namespace App\Modules\HtlCampBooking\Domain;

use App\Modules\Shared\Domain\ErrorDictionary;
use App\Modules\Shared\Exceptions\BasicRequestException;

class HtlCampBookingNotFound extends BasicRequestException
{
    public function __construct()
    {
        parent::__construct(
            404,
            ErrorDictionary::ERRORS['OWNER']['HTL_CAMP_BOOKING']['HTL_CAMP_BOOKING_FIND']['HTL_CAMP_BOOKING_NOT_FOUND'],
            'Reserva de campamento no encontrado'
        );
    }
}
