<?php

namespace App\Modules\HtlCampBooking\Application\Create;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampBooking\Domain\HtlCampBooking;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingAmount;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingAmountTotal;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingDate;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingDateStart;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingLock;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingRemark;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingStatus;
use App\Modules\HtlCampSchedule\Application\AddUsage\AddUsageHtlCampScheduleQuery;
use App\Modules\HtlCampSchedule\Application\Availability\AvailabilityHtlCampScheduleQuery;
use App\Modules\HtlCampSchedule\Application\HtlCampScheduleResponse;
use App\Modules\HtlCampSchedule\Domain\HtlCampSchedule;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use Illuminate\Support\Facades\DB;

final class CreateHtlCampBookingQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampBookingCreator $creator,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(CreateHtlCampBookingQuery $query): CreateHtlCampBookingResponse
    {
        /** @var HtlCampScheduleResponse $campSchedule */
        $campSchedule = $this->queryBus->ask(new AvailabilityHtlCampScheduleQuery($query->idHtlCamp(), $query->dateStart(), $query->amount()));

        $model = new HtlCampBooking(
            new IdHtlCampBooking(0),
            new HtlCampBookingDate($query->date()),
            new HtlCampBookingDateStart($query->dateStart()),
            new HtlCampBookingAmount($query->amount()),
            new HtlCampBookingAmountTotal($query->amountTotal()),
            new HtlCampBookingStatus($query->status()),
            new HtlCampBookingLock($query->lock()),
            new HtlCampBookingRemark($query->remark()),
            new IdHtlCampSchedule($campSchedule->Id_HtlCampSchedule),
            new IdBookingTour($query->idBookingTour()),
        );
        $create = $this->creator->__invoke($model);
        if ($query->status() == HtlCampBookingStatus::ACTIVE) {
            $this->queryBus->ask(new AddUsageHtlCampScheduleQuery($query->idHtlCamp(), $query->dateStart(), $query->amount()));
        }
        return new CreateHtlCampBookingResponse($create);
    }
}
