<?php

namespace App\Modules\HtlCamp\Domain;

use App\Modules\HtlTypeCamp\Domain\IdHtlTypeCamp;

class UpdateHtlCamp
{

    /** constructor */
    public function __construct(
        private HtlCampName $name,
        private HtlCampAbrv $abrv,
        private HtlCampIcon $icon,
        private HtlCampIconThumb $iconThumb,
        private HtlCampAvailability $availability,
        private HtlCampOrder $order,
        private HtlCampStatus $status,
        private IdHtlTypeCamp $idHtlTypeCamp,
        private ?IdHtlCamp $id = NULL
    ) {
    }

    public function getName(): HtlCampName
    {
        return $this->name;
    }
    public function getAbrv(): HtlCampAbrv
    {
        return $this->abrv;
    }
    public function getIcon(): HtlCampIcon
    {
        return $this->icon;
    }
    public function getIconThumb(): HtlCampIconThumb
    {
        return $this->iconThumb;
    }
    public function getAvailability(): HtlCampAvailability
    {
        return $this->availability;
    }
    public function getOrder(): HtlCampOrder
    {
        return $this->order;
    }
    public function getStatus(): HtlCampStatus
    {
        return $this->status;
    }
    public function getIdHtlTypeCamp(): IdHtlTypeCamp
    {
        return $this->idHtlTypeCamp;
    }
    public function getId(): IdHtlCamp
    {
        return $this->id;
    }
}
