<?php

namespace App\Modules\HtlBed\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateHtlBedQuery implements Query
{
    public function __construct(
        private int $id,
        private string $name,
        private string $description,
        private int $availability,
        private int $status,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function name(): string
    {
        return $this->name;
    }

    public function description(): string
    {
        return $this->description;
    }

    public function availability(): int
    {
        return $this->availability;
    }

    public function status(): int
    {
        return $this->status;
    }
}
