<?php

namespace App\Modules\History\Application\ListCount;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ListCountHistoryQuery implements Query
{
    public function __construct(
        private string $dateStart,
        private string $dateEnd,
        private int $idHistoryTable,
        private int $idReference,
        private string $Action,
    ) {
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function dateEnd(): string
    {
        return $this->dateEnd;
    }

    public function getIdHistoryTable(): int
    {
        return $this->idHistoryTable;
    }

    public function getIdReference(): int
    {
        return $this->idReference;
    }

    public function getAction()
    {
        return $this->Action;
    }
}
