<?php

namespace App\Modules\History\Application\List;

use App\Modules\History\Domain\HistoryList;
use App\Modules\History\Domain\IdHistoryReference;
use App\Modules\HistoryTable\Domain\IdHistoryTable;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;

final class ListHistoryQueryHandler implements QueryHandler
{
    public function __construct(private HistoryLister $lister)
    {
    }

    public function __invoke(ListHistoryQuery $query): ListHistoryResponses
    {
        return new ListHistoryResponses(...array_map(
            fn (HistoryList $index) => new ListHistoryResponse(
                $index->id()->value(),
                $index->date()->value(),
                $index->valueOld()->value(),
                $index->valueNew()->value(),
                $index->operation()->value(),
                $index->idRecord()->value(),
                $index->idReference()->value(),
                $index->idAdmin()->value(),
                $index->adminName()->value(),
                $index->adminLastName()->value(),
                $index->adminNoDocument()->value(),
                $index->idHistoryTable()->value(),
                $index->historyTableName()->value(),
                $index->historyTableTitle()->value(),
            ),
            $this->lister->__invoke(
                new DateStart($query->dateStart()),
                new DateEnd($query->dateEnd()),
                new IdHistoryTable($query->getIdHistoryTable()),
                new IdHistoryReference($query->getIdReference()),
                QueryPaginate::fromData($query->page(), $query->pageSize()),
                $query->getAction()
            )
        ));
    }
}
