<?php

namespace App\Modules\GroupProviderReview\Infraestructure;

class GroupProviderReviewValidators
{

    public const INSERT = [
        'ExternalUser_NickName'         => 'string|max:250',
        'ExternalUser_Name'             => 'required|string|max:250',
        'GroupProviderReview_DateReview'     => 'required|string',
        'GroupProviderReview_Route'          => 'string|max:250',
        'GroupProviderReview_Title'          => 'string|max:250',
        'GroupProviderReview_Value'          => 'string|max:5000',
        'GroupProviderReview_Score'          => 'required|int',
        'GroupProviderReview_Type'           => 'required|int',
        'GroupProviderReview_Status'         => 'required|int',
        'Id_ExternalUser'               => 'required|int',
        'Id_GroupPassenger'             => 'required|int',
        'Id_BookingRelationship'        => 'required|int',
        'Id_Language'                   => 'required|int',
        'Id_External'                   => 'required|int',
        'Id_Admin'                      => 'required|int',
        'Id_GroupProviderReview_Parent'      => 'required|int',
        'GroupProviderReviewProvider'        => 'required|string'
    ];

    public const GROUP_PROVIDER = [
        'GroupProviderReviewProvider.*.Id_GroupProvider' => 'required|int',
        'GroupProviderReviewProvider.*.GroupProviderReviewProvider_Type' => 'required|int',
    ];

    public const UPDATE_GROUP_PROVIDER = [
        'GroupProviderReviewProvider.*.GroupProviderReviewProvider_Type' => 'required|int',
        'GroupProviderReviewProvider.*.GroupProviderReviewProvider_Status' => 'required|int',
        'GroupProviderReviewProvider.*.Id_GroupProviderReview' => 'required|int',
        'GroupProviderReviewProvider.*.Id_GroupProvider' => 'required|int',
        'GroupProviderReviewProvider.*.Id_GroupProviderReviewProvider' => 'required|int',
    ];

    public const UPDATE = [
        'Id_GroupProviderReview'             => 'required|int',
        'ExternalUser_NickName'         => 'string|max:250',
        'ExternalUser_Name'             => 'required|string|max:250',
        'GroupProviderReview_DateReview'     => 'required|string',
        'GroupProviderReview_Route'          => 'string|max:250',
        'GroupProviderReview_Title'          => 'string|max:250',
        'GroupProviderReview_Value'          => 'string|max:5000',
        'GroupProviderReview_Score'          => 'required|int',
        'GroupProviderReview_Type'           => 'required|int',
        'GroupProviderReview_Status'         => 'required|int',
        'Id_ExternalUser'               => 'required|int',
        'Id_GroupPassenger'             => 'required|int',
        'Id_BookingRelationship'        => 'required|int',
        'Id_Language'                   => 'required|int',
        'Id_External'                   => 'required|int',
        'Id_Admin'                      => 'required|int',
        'Id_GroupProviderReview_Parent'      => 'required|int',
        'GroupProviderReviewProvider'        => 'required|string'
    ];

    public const FIND = [
        'DateStart'                     => 'required|string|date',
        'DateEnd'                       => 'required|string|date'
    ];
}
