<?php

namespace App\Modules\GroupProviderReview\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\BookingRelationship\Domain\IdBookingRelationship;
use App\Modules\External\Domain\IdExternal;
use App\Modules\ExternalUser\Domain\IdExternalUser;
use App\Modules\ExternalUserPassenger\Domain\IdExternalUserPassenger;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Language\Domain\IdLanguage;

class GroupProviderReview
{

    public function __construct(
        private GroupProviderReviewDate $date,
        private GroupProviderReviewDateReview $dateReview,
        private GroupProviderReviewRoute $route,
        private GroupProviderReviewTitle $title,
        private GroupProviderReviewValue $value,
        private GroupProviderReviewScore $score,
        private GroupProviderReviewType $type,
        private GroupProviderReviewStatus $status,
        private IdExternalUser $idExternalUser,
        private IdExternalUserPassenger $idExternalUserPassenger,
        private IdGroupProvider $idGroupProvider,
        private IdGroupPassenger $idGroupPassenger,
        private IdBookingRelationship $idBookingRelationship,
        private IdLanguage $idLanguage,
        private IdExternal $idExternal,
        private IdAdmin $idAdmin,
        private IdGroupProviderReview $idGroupProviderReview_Parent,
        private ?IdGroupProviderReview $id = null
    ) {
    }

    public function getGroupProviderReviewDate(): GroupProviderReviewDate
    {
        return $this->date;
    }
    public function getGroupProviderReviewDateReview(): GroupProviderReviewDateReview
    {
        return $this->dateReview;
    }
    public function getGroupProviderReviewRoute(): GroupProviderReviewRoute
    {
        return $this->route;
    }
    public function getGroupProviderReviewTitle(): GroupProviderReviewTitle
    {
        return $this->title;
    }
    public function getGroupProviderReviewValue(): GroupProviderReviewValue
    {
        return $this->value;
    }
    public function getGroupProviderReviewScore(): GroupProviderReviewScore
    {
        return $this->score;
    }
    public function getGroupProviderReviewType(): GroupProviderReviewType
    {
        return $this->type;
    }
    public function getGroupProviderReviewStatus(): GroupProviderReviewStatus
    {
        return $this->status;
    }
    public function getIdExternalUser(): IdExternalUser
    {
        return $this->idExternalUser;
    }
    public function getIdExternalUserPassenger(): IdExternalUserPassenger
    {
        return $this->idExternalUserPassenger;
    }
    public function getIdGroupProvider(): IdGroupProvider
    {
        return $this->idGroupProvider;
    }
    public function getIdGroupPassenger(): IdGroupPassenger
    {
        return $this->idGroupPassenger;
    }
    public function getIdBookingRelationship(): IdBookingRelationship
    {
        return $this->idBookingRelationship;
    }
    public function getIdLanguage(): IdLanguage
    {
        return $this->idLanguage;
    }
    public function getIdExternal(): IdExternal
    {
        return $this->idExternal;
    }
    public function getIdAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }
    public function getIdGroupProviderReview(): IdGroupProviderReview
    {
        return $this->idGroupProviderReview_Parent;
    }
    public function getId(): IdGroupProviderReview
    {
        return $this->id;
    }
}
