<?php

namespace App\Modules\GroupProviderMedia\Domain;

use App\Modules\Media\Domain\MediaType;
use App\Modules\Shared\Domain\ValueObject\EnumValueObject;
use App\Modules\Shared\Domain\ValueObject\IntValueObject;

class GroupProviderMediaType extends EnumValueObject
{

    public const IMAGE = 1;
    public const VIDEO = 2;

    public static function values()
    {
        return [
            self::IMAGE,
            self::VIDEO
        ];
    }

    public static function fromMediaType(int $mediaType)
    {
        if ($mediaType == MediaType::IMAGE) {
            return new self(self::IMAGE);
        } else if ($mediaType == MediaType::VIDEO) {
            return new self(self::VIDEO);
        }
        throw new GroupProviderMediaTypeNotAccepted();
    }
}
