<?php

namespace App\Modules\GroupProviderMedia\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateGroupProviderMediaQuery implements Query
{
    public function __construct(
        private int $id,
        private string $path,
        private string $pathThumb,
        private string $pathLargeThumb,
        private string $extension,
        private int $size,
        private int $type,
        private string $error,
        private int $status,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function path(): string
    {
        return $this->path;
    }

    public function pathThumb(): string
    {
        return $this->pathThumb;
    }

    public function pathLargeThumb(): string
    {
        return $this->pathLargeThumb;
    }

    public function extension(): string
    {
        return $this->extension;
    }

    public function size(): int
    {
        return $this->size;
    }

    public function type(): int
    {
        return $this->type;
    }

    public function error(): string
    {
        return $this->error;
    }

    public function status(): int
    {
        return $this->status;
    }
}
