<?php

namespace App\Modules\GroupProvider\Infraestructure;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\GroupProvider\Domain\GroupProviderReportRepository;
use App\Modules\TypeProvider\Domain\IdTypeProvider;
use Illuminate\Support\Facades\DB;

class MysqlGroupProviderReportRepository implements GroupProviderReportRepository
{

    public function report(GroupDateStart $dateStart, GroupDateEnd $dateEnd)
    {
        $object = DB::select(
            "SELECT `t`.`Tour_Code` AS `Tour`,
                    `gpv_aux`.`Id_Provider` AS `IdProv`,
                    CONCAT(`gpv_aux`.`Provider_NickName`) AS `Proveedor`,
                    DAYOFMONTH(`gpv_aux`.`Group_DateStart`) AS `Dia_ida`,
                    MONTH(`gpv_aux`.`Group_DateStart`) AS `Mes_ida`,
                    YEAR(`gpv_aux`.`Group_DateStart`) AS `Anho_ida`,
                    DAYOFMONTH(`gpv_aux`.`Group_DateEnd`) AS `Dia_retorno`,
                    MONTH(`gpv_aux`.`Group_DateEnd`) AS `Mes_retorno`,
                    YEAR(`gpv_aux`.`Group_DateEnd`) AS `Anho_retorno`,
                    `t`.`Tour_Duration` AS `NoDias`,
                    ( CASE WHEN `gpv_aux`.`GroupProvider_AnsweredReview` = 2 THEN 'SI' ELSE 'NO' END ) AS `Tiene_Review`,
                    DAYOFMONTH(`gpr`.`GroupProviderReview_DateUpdate`) AS `Dia_llenado`,
                    MONTH(`gpr`.`GroupProviderReview_DateUpdate`) AS `Mes_llenado`,
                    YEAR(`gpr`.`GroupProviderReview_DateUpdate`) AS `Anho_llenado`,
                    (
                        CONCAT(
                        '[',
                        GROUP_CONCAT(DISTINCT JSON_OBJECT(
                            'Id_Provider',              `gpv_p`.`Id_Provider`,
                            'Provider_BusinessName',    `gpv_p`.`Provider_BusinessName`,
                            'Id_TypeProvider',          `gpv_tp`.`Id_TypeProvider`,
                            'TypeProvider_Name',        `gpv_tp`.`TypeProvider_Name`
                            ) SEPARATOR ','),
                        ']'
                        )
                    ) AS `GroupProvider_JSON`,
                    (
                        CONCAT(
                        '[',
                        GROUP_CONCAT(DISTINCT JSON_OBJECT(
                            'Id_GroupProviderReview',       `gpr`.`Id_GroupProviderReview`,
                            'GroupProviderReview_Status',   `gpr`.`GroupProviderReview_Status`,
                            'GroupProviderReview_Values',   `gpr`.`GroupProviderReview_Values`,
                            'GroupProviderReview_Comment',  `gpr`.`GroupProviderReview_Comment`,
                            'GroupProviderReview_Score',    `gpr`.`GroupProviderReview_Score`,
                            'GroupProviderReview_DateUpdate', `gpr`.`GroupProviderReview_DateUpdate`,
                            'GroupProviderReview_AdminComment',  `gpr`.`GroupProviderReview_AdminComment`,
                            'GroupProviderReview_AdminCommentDateUpdate',  `gpr`.`GroupProviderReview_AdminCommentDateUpdate`,
                            'Id_Provider',              `pv`.`Id_Provider`,
                            'Provider_BusinessName',    `pv`.`Provider_BusinessName`,
                            'Id_TypeProvider',          `tp`.`Id_TypeProvider`,
                            'TypeProvider_Name',        `tp`.`TypeProvider_Name`,
                            'Id_Question',              `q`.`Id_Question`,
                            'Question_Type',            `q`.`Question_Type`,
                            'Question_General',         `q`.`Question_General`
                            ) SEPARATOR ','),
                        ']'
                        )
                    ) AS `GroupProviderReviewAll_JSON`
            FROM (
                    SELECT  `pv`.`Id_Provider`,
                            `pv`.`Provider_NickName`,
                            `gpv`.`Id_GroupProvider`,
                            `gpv`.`GroupProvider_Type`,
                            `gpv`.`GroupProvider_AnsweredReview`,
                            `g`.`Id_Group`,
                            `g`.`Group_DateStart`,
                            `g`.`Group_DateEnd`,
                            `g`.`Id_Service`
                    FROM    `t_group_provider` AS `gpv` INNER JOIN
                            `t_group` AS `g` ON `g`.`Id_Group` = `gpv`.`Id_Group` AND `g`.`Group_ServiceType` IN (1, 2) INNER JOIN
                            `t_provider` AS `pv` ON `pv`.`Id_Provider` = `gpv`.`Id_Provider`
                    WHERE   `g`.`Group_DateStart` BETWEEN ? AND ?
                    AND     `pv`.`Id_TypeProvider` IN (" . IdTypeProvider::GUIDES_WHERE . ")
                )   `gpv_aux` INNER JOIN
                `t_tour`                    AS `t`      ON `t`.`Id_Tour` = `gpv_aux`.`Id_Service` LEFT JOIN
                `t_group_provider`          AS `gpv`    ON `gpv`.`Id_Group` = `gpv_aux`.`Id_Group` LEFT JOIN
                `t_provider`                AS `gpv_p`  ON `gpv_p`.`Id_Provider` = `gpv`.`Id_Provider`LEFT JOIN
                `t_type_provider`           AS `gpv_tp` ON `gpv_tp`.`Id_TypeProvider` = `gpv_p`.`Id_TypeProvider` LEFT JOIN
                `t_group_provider_review`   AS `gpr`    ON `gpr`.`Id_GroupProvider` = `gpv_aux`.`Id_GroupProvider` AND `gpv_aux`.`GroupProvider_AnsweredReview` = 2 LEFT JOIN
                `t_question`                AS `q`      ON `q`.`Id_Question` = `gpr`.`Id_Question` LEFT JOIN
                `t_provider`                AS `pv`     ON `gpr`.`Id_Provider` = `pv`.`Id_Provider` LEFT JOIN
                `t_type_provider`           AS `tp`     ON `tp`.`Id_TypeProvider` = `pv`.`Id_TypeProvider`
            GROUP BY `gpv_aux`.`Id_GroupProvider`
            ORDER BY `gpv_aux`.`Group_DateStart` DESC, `gpv_aux`.`Id_GroupProvider` ASC
            ",
            
            [
                $dateStart->value(),
                $dateEnd->value()
            ]
        );
        $objects = $this->generateObjects($object);
        return $objects;
    }

    private function genRows(&$obj, &$keys)
    {
        return '<tr>' . implode('', array_map(fn($key) => '<td>' . $obj->$key . '</td>', $keys)) . "</tr>\n";
    }

    private function generateObjects($listGroupPassenger)
    {
        return array_map(fn($groupProviderReview) => $this->generateObject($groupProviderReview), $listGroupPassenger);
    }

    private function generateObject($groupProviderReview)
    {
        $GroupProviderReviewAll = json_decode($groupProviderReview->GroupProviderReviewAll_JSON);
        $groupProviderAll = json_decode($groupProviderReview->GroupProvider_JSON);
        unset($groupProviderReview->GroupProviderReviewAll_JSON);
        unset($groupProviderReview->GroupProvider_JSON);
        $Global = $this->findGeneralScoreClean($GroupProviderReviewAll);
        $Guide = $this->findTypeProvider($GroupProviderReviewAll, 1);
        $SecondGuide = $this->findTypeProvider($GroupProviderReviewAll, 2);
        $Chef = $this->findTypeProvider($GroupProviderReviewAll, 3);
        $RestaurantMollepata = $this->findProviderName($GroupProviderReviewAll, 6, 'Mollepata');
        $RestaurantAguas = $this->findProviderName($GroupProviderReviewAll, 6, 'Aguas Calientes');
        $Transport = $this->findTypeProvider($GroupProviderReviewAll, 5);
        $Horseman = $this->findTypeProvider($GroupProviderReviewAll, 4);
        $CampsSkyCamp = $this->findProviderName($GroupProviderReviewAll, 15, 'Sky Camp');
        $CampsSkyView = $this->findProviderName($GroupProviderReviewAll, 15, 'Mountain Sky View');
        $CampsJungle = $this->findProviderName($GroupProviderReviewAll, 15, 'Jungle Domes');
        $CampsAndean = $this->findProviderName($GroupProviderReviewAll, 15, 'Andean Huts');
        $Hotel = $this->findTypeProvider($GroupProviderReviewAll, 8);
        $Recomend = $this->findQuestion($GroupProviderReviewAll, 16);
        $RecomendWhy = $this->findQuestion($GroupProviderReviewAll, 17);
        $Contact = $this->findQuestion($GroupProviderReviewAll, 18);
        $Moments = $this->findQuestion($GroupProviderReviewAll, 11);
        $Comments = $this->findQuestion($GroupProviderReviewAll, 13);

        $ProvGuide = $this->findTypeProvider($groupProviderAll, 1);
        $ProvSecondGuide = $this->findTypeProvider($groupProviderAll, 2);
        $ProvChef = $this->findTypeProvider($groupProviderAll, 3);
        $ProvRestaurantMollepata = $this->findProviderName($groupProviderAll, 6, 'Mollepata');
        $ProvRestaurantAguas = $this->findProviderName($groupProviderAll, 6, 'Aguas Calientes');
        $ProvTransport = $this->findTypeProvider($groupProviderAll, 5);
        $ProvHorseman = $this->findTypeProvider($groupProviderAll, 4);
        $ProvCampsSkyCamp = $this->findProviderName($groupProviderAll, 15, 'Sky Camp');
        $ProvCampsSkyView = $this->findProviderName($groupProviderAll, 15, 'Mountain Sky View');
        $ProvCampsJungle = $this->findProviderName($groupProviderAll, 15, 'Jungle Domes');
        $ProvCampsAndean = $this->findProviderName($groupProviderAll, 15, 'Andean Huts');
        $ProvHotel = $this->findTypeProvider($groupProviderAll, 8);
        
        $groupProviderReview->Global_Score = $this->getAllFrom($Global, fn($g) => $g->GroupProviderReview_Score);
        
        $groupProviderReview->Guide_Name = $this->getAllFrom($Guide, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->Guide_Score = $this->getAllFrom($Guide, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->Guide_Comment = $this->getAllFrom($Guide, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->SecondGuide_Name = $this->getAllFrom($SecondGuide, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->SecondGuide_Score = $this->getAllFrom($SecondGuide, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->SecondGuide_Comment = $this->getAllFrom($SecondGuide, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->Chef_Name = $this->getAllFrom($Chef, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->Chef_Score = $this->getAllFrom($Chef, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->Chef_Comment = $this->getAllFrom($Chef, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->RestaurantMollepata_Name = $this->getAllFrom($RestaurantMollepata, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->RestaurantMollepata_Score = $this->getAllFrom($RestaurantMollepata, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->RestaurantMollepata_Comment = $this->getAllFrom($RestaurantMollepata, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->RestaurantAguas_Name = $this->getAllFrom($RestaurantAguas, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->RestaurantAguas_Score = $this->getAllFrom($RestaurantAguas, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->RestaurantAguas_Comment = $this->getAllFrom($RestaurantAguas, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->Transport_Name = $this->getAllFrom($Transport, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->Transport_Score = $this->getAllFrom($Transport, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->Transport_Comment = $this->getAllFrom($Transport, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->Horseman_Name = $this->getAllFrom($Horseman, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->Horseman_Score = $this->getAllFrom($Horseman, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->Horseman_Comment = $this->getAllFrom($Horseman, fn($g) => $g->GroupProviderReview_Comment);

        $groupProviderReview->CampsSkyCamp_Name = $this->getAllFrom($CampsSkyCamp, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->CampsSkyCamp_Score = $this->getAllFrom($CampsSkyCamp, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->CampsSkyCamp_Comment = $this->getAllFrom($CampsSkyCamp, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->CampsSkyView_Name = $this->getAllFrom($CampsSkyView, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->CampsSkyView_Score = $this->getAllFrom($CampsSkyView, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->CampsSkyView_Comment = $this->getAllFrom($CampsSkyView, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->CampsJungle_Name = $this->getAllFrom($CampsJungle, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->CampsJungle_Score = $this->getAllFrom($CampsJungle, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->CampsJungle_Comment = $this->getAllFrom($CampsJungle, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->CampsAndean_Name = $this->getAllFrom($CampsAndean, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->CampsAndean_Score = $this->getAllFrom($CampsAndean, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->CampsAndean_Comment = $this->getAllFrom($CampsAndean, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->Hotel_Name = $this->getAllFrom($Hotel, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->Hotel_Score = $this->getAllFrom($Hotel, fn($g) => $g->GroupProviderReview_Score);
        $groupProviderReview->Hotel_Comment = $this->getAllFrom($Hotel, fn($g) => $g->GroupProviderReview_Comment);
        
        $groupProviderReview->Recomend_Comment = $this->getAllFrom($Recomend, fn($g) => $this->getRecomend($g->GroupProviderReview_Values));
        $groupProviderReview->RecomendWhy_Comment = $this->getAllFrom($RecomendWhy, fn($g) => $g->GroupProviderReview_Comment);

        $groupProviderReview->Trip_Advisor = $this->getAllFrom($Contact, fn($g) => $this->getContact($g->GroupProviderReview_Values, 0));
        $groupProviderReview->Google = $this->getAllFrom($Contact, fn($g) => $this->getContact($g->GroupProviderReview_Values, 1));
        $groupProviderReview->Social_Network = $this->getAllFrom($Contact, fn($g) => $this->getContact($g->GroupProviderReview_Values, 2));
        $groupProviderReview->Referencias = $this->getAllFrom($Contact, fn($g) => $this->getContact($g->GroupProviderReview_Values, 3));
        $groupProviderReview->Otros = $this->getAllFrom($Contact, fn($g) => $this->getContact($g->GroupProviderReview_Values, 4));
        $groupProviderReview->Moments_Comment = $this->getAllFrom($Moments, fn($g) => $g->GroupProviderReview_Comment);
        $groupProviderReview->Comments_Suggestions = $this->getAllFrom($Comments, fn($g) => $g->GroupProviderReview_Comment);

        $groupProviderReview->GPGuide_Name = $this->getAllFrom($ProvGuide, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPSecondGuide_Name = $this->getAllFrom($ProvSecondGuide, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPChef_Name = $this->getAllFrom($ProvChef, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPRestaurantMollepata_Name = $this->getAllFrom($ProvRestaurantMollepata, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPRestaurantAguas_Name = $this->getAllFrom($ProvRestaurantAguas, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPTransport_Name = $this->getAllFrom($ProvTransport, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPHorseman_Name = $this->getAllFrom($ProvHorseman, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPCampsSkyCamp_Name = $this->getAllFrom($ProvCampsSkyCamp, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPCampsSkyView_Name = $this->getAllFrom($ProvCampsSkyView, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPCampsJungle_Name = $this->getAllFrom($ProvCampsJungle, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPCampsAndean_Name = $this->getAllFrom($ProvCampsAndean, fn($g) => $g->Provider_BusinessName);
        $groupProviderReview->GPHotel_Name = $this->getAllFrom($ProvHotel, fn($g) => $g->Provider_BusinessName);
        
        return $groupProviderReview;
    }

    private function getContact($values, $index)
    {
        $contact = json_decode($values);
        if (!isset($contact[$index]->selected)) {
            return '';
        }
        if ($contact[$index]->selected) {
            return 'Sí';
        }
        return '';
    }

    private function getRecomend($values)
    {
        $data = json_decode($values);
        if ($data[0]->selected) {
            return 'Sí';
        }
        if ($data[1]->selected) {
            return 'No';
        }
        return '';
    }

    private function getAllFrom($reviewArray, $callable)
    {
        return implode(',', array_map($callable, $reviewArray));
    }

    private function findGeneralScoreClean($reviewAll)
    {
        $find = [];
        foreach ($reviewAll as $value) {
            if ($value->Id_TypeProvider == null && $value->Question_General == 2 && in_array($value->Question_Type, [1, 3, 8])) {
                $find[] = $value;
            }
        }
        return $find;
    }

    private function findQuestion($reviewAll, $idQuestion)
    {
        $find = [];
        foreach ($reviewAll as $value) {
            if ($value->Id_Question == $idQuestion) {
                $find[] = $value;
            }
        }
        return $find;
    }

    private function findTypeProvider($reviewAll, $idTypeProvider)
    {
        $find = [];
        foreach ($reviewAll as $value) {
            if ($value->Id_TypeProvider == $idTypeProvider) {
                $find[] = $value;
            }
        }
        return $find;
    }

    private function findProviderName($reviewAll, $idTypeProvider, $ProviderName)
    {
        $find = [];
        foreach ($reviewAll as $value) {
            if ($value->Id_TypeProvider == $idTypeProvider && str_contains($value->Provider_BusinessName, $ProviderName)) {
                $find[] = $value;
            }
        }
        return $find;
    }
}
