<?php

namespace App\Modules\GroupProvider\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexGroupProvider implements StorageCriteria
{

    public function __construct(
        private IdGroupProvider $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupProvider::select('`gp`');

        return DB::select(
            "SELECT $select
            FROM `t_group_provider` `gp`
            WHERE `gp`.`Id_GroupProvider` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new GroupProviderNotFound();
        }
        return GroupProvider::fromDTO($data[0]);
    }
}
