<?php

namespace App\Modules\GroupProvider\Application\UpdateMediaScore;

use App\Modules\GroupProvider\Application\Index\GroupProviderIndexer;
use App\Modules\GroupProvider\Domain\GroupProvider;
use App\Modules\GroupProvider\Domain\GroupProviderMediaDateUpdate;
use App\Modules\GroupProvider\Domain\GroupProviderMediaScore;
use App\Modules\GroupProvider\Domain\GroupProviderMediaStatus;
use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

final class MediaScoreGroupProviderUpdater
{
    public function __construct(
        private GroupProviderRepository $repository,
        private QueryBus $queryBus,
        private GroupProviderIndexer $groupPassengerIndexer
    ) {
    }

    public function __invoke(IdGroupProvider $id, GroupProviderMediaScore $mediaScore)
    {
        /** @var GroupProvider $index */
        $index = $this->groupPassengerIndexer->__invoke($id);
        $index->setMediaStatus(new GroupProviderMediaStatus(GroupProviderMediaStatus::SCORED));
        // $index->setMediaDateUpdate(GroupProviderMediaDateUpdate::reduceDatetimeToPeru(GroupProviderMediaDateUpdate::now()));
        $index->setMediaScore($mediaScore);
        return $this->repository->updateModel($index);
    }
}
